@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Specifies information about the capacity reservation group that the capacity reservations should be assigned to. Currently, a capacity reservation can only be added to a capacity reservation group at creation time. An existing capacity reservation cannot be added or moved to another capacity reservation group.
 * @property capacityReservations A list of all capacity reservation resource ids that belong to capacity reservation group.
 * @property id Resource Id
 * @property instanceView The capacity reservation group instance view which has the list of instance views for all the capacity reservations that belong to the capacity reservation group.
 * @property location Resource location
 * @property name Resource name
 * @property tags Resource tags
 * @property type Resource type
 * @property virtualMachinesAssociated A list of references to all virtual machines associated to the capacity reservation group.
 * @property zones Availability Zones to use for this capacity reservation group. The zones can be assigned only during creation. If not provided, the group supports only regional resources in the region. If provided, enforces each capacity reservation in the group to be in one of the zones.
 */
public data class GetCapacityReservationGroupResult(
    public val capacityReservations: List<SubResourceReadOnlyResponse>,
    public val id: String,
    public val instanceView: CapacityReservationGroupInstanceViewResponse,
    public val location: String,
    public val name: String,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val virtualMachinesAssociated: List<SubResourceReadOnlyResponse>,
    public val zones: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.GetCapacityReservationGroupResult): GetCapacityReservationGroupResult = GetCapacityReservationGroupResult(
            capacityReservations = javaType.capacityReservations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.SubResourceReadOnlyResponse.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            instanceView = javaType.instanceView().let({ args0 ->
                com.pulumi.azurenative.compute.kotlin.outputs.CapacityReservationGroupInstanceViewResponse.Companion.toKotlin(args0)
            }),
            location = javaType.location(),
            name = javaType.name(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            virtualMachinesAssociated = javaType.virtualMachinesAssociated().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.SubResourceReadOnlyResponse.Companion.toKotlin(args0)
                })
            }),
            zones = javaType.zones().map({ args0 -> args0 }),
        )
    }
}
