@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Specifies information about the Dedicated host.
 * @property autoReplaceOnFailure Specifies whether the dedicated host should be replaced automatically in case of a failure. The value is defaulted to 'true' when not provided.
 * @property hostId A unique id generated and assigned to the dedicated host by the platform. Does not change throughout the lifetime of the host.
 * @property id Resource Id
 * @property instanceView The dedicated host instance view.
 * @property licenseType Specifies the software license type that will be applied to the VMs deployed on the dedicated host. Possible values are: **None,** **Windows_Server_Hybrid,** **Windows_Server_Perpetual.** The default value is: **None.**
 * @property location Resource location
 * @property name Resource name
 * @property platformFaultDomain Fault domain of the dedicated host within a dedicated host group.
 * @property provisioningState The provisioning state, which only appears in the response.
 * @property provisioningTime The date when the host was first provisioned.
 * @property sku SKU of the dedicated host for Hardware Generation and VM family. Only name is required to be set. List Microsoft.Compute SKUs for a list of possible values.
 * @property tags Resource tags
 * @property timeCreated Specifies the time at which the Dedicated Host resource was created. Minimum api-version: 2021-11-01.
 * @property type Resource type
 * @property virtualMachines A list of references to all virtual machines in the Dedicated Host.
 */
public data class GetDedicatedHostResult(
    public val autoReplaceOnFailure: Boolean? = null,
    public val hostId: String,
    public val id: String,
    public val instanceView: DedicatedHostInstanceViewResponse,
    public val licenseType: String? = null,
    public val location: String,
    public val name: String,
    public val platformFaultDomain: Int? = null,
    public val provisioningState: String,
    public val provisioningTime: String,
    public val sku: SkuResponse,
    public val tags: Map<String, String>? = null,
    public val timeCreated: String,
    public val type: String,
    public val virtualMachines: List<SubResourceReadOnlyResponse>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.GetDedicatedHostResult): GetDedicatedHostResult = GetDedicatedHostResult(
            autoReplaceOnFailure = javaType.autoReplaceOnFailure().map({ args0 -> args0 }).orElse(null),
            hostId = javaType.hostId(),
            id = javaType.id(),
            instanceView = javaType.instanceView().let({ args0 ->
                com.pulumi.azurenative.compute.kotlin.outputs.DedicatedHostInstanceViewResponse.Companion.toKotlin(args0)
            }),
            licenseType = javaType.licenseType().map({ args0 -> args0 }).orElse(null),
            location = javaType.location(),
            name = javaType.name(),
            platformFaultDomain = javaType.platformFaultDomain().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            provisioningTime = javaType.provisioningTime(),
            sku = javaType.sku().let({ args0 ->
                com.pulumi.azurenative.compute.kotlin.outputs.SkuResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            timeCreated = javaType.timeCreated(),
            type = javaType.type(),
            virtualMachines = javaType.virtualMachines().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.SubResourceReadOnlyResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
