@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The Private Endpoint Connection resource.
 * @property id private endpoint connection Id
 * @property name private endpoint connection name
 * @property privateEndpoint The resource of private end point.
 * @property privateLinkServiceConnectionState A collection of information about the state of the connection between DiskAccess and Virtual Network.
 * @property provisioningState The provisioning state of the private endpoint connection resource.
 * @property type private endpoint connection type
 */
public data class GetDiskAccessAPrivateEndpointConnectionResult(
    public val id: String,
    public val name: String,
    public val privateEndpoint: PrivateEndpointResponse,
    public val privateLinkServiceConnectionState: PrivateLinkServiceConnectionStateResponse,
    public val provisioningState: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.GetDiskAccessAPrivateEndpointConnectionResult): GetDiskAccessAPrivateEndpointConnectionResult =
            GetDiskAccessAPrivateEndpointConnectionResult(
                id = javaType.id(),
                name = javaType.name(),
                privateEndpoint = javaType.privateEndpoint().let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.PrivateEndpointResponse.Companion.toKotlin(args0)
                }),
                privateLinkServiceConnectionState = javaType.privateLinkServiceConnectionState().let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.PrivateLinkServiceConnectionStateResponse.Companion.toKotlin(args0)
                }),
                provisioningState = javaType.provisioningState(),
                type = javaType.type(),
            )
    }
}
