@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * disk access resource.
 * @property extendedLocation The extended location where the disk access will be created. Extended location cannot be changed.
 * @property id Resource Id
 * @property location Resource location
 * @property name Resource name
 * @property privateEndpointConnections A readonly collection of private endpoint connections created on the disk. Currently only one endpoint connection is supported.
 * @property provisioningState The disk access resource provisioning state.
 * @property tags Resource tags
 * @property timeCreated The time when the disk access was created.
 * @property type Resource type
 */
public data class GetDiskAccessResult(
    public val extendedLocation: ExtendedLocationResponse? = null,
    public val id: String,
    public val location: String,
    public val name: String,
    public val privateEndpointConnections: List<PrivateEndpointConnectionResponse>,
    public val provisioningState: String,
    public val tags: Map<String, String>? = null,
    public val timeCreated: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.GetDiskAccessResult): GetDiskAccessResult = GetDiskAccessResult(
            extendedLocation = javaType.extendedLocation().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            privateEndpointConnections = javaType.privateEndpointConnections().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.PrivateEndpointConnectionResponse.Companion.toKotlin(args0)
                })
            }),
            provisioningState = javaType.provisioningState(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            timeCreated = javaType.timeCreated(),
            type = javaType.type(),
        )
    }
}
