@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Disk resource.
 * @property burstingEnabled Set to true to enable bursting beyond the provisioned performance target of the disk. Bursting is disabled by default. Does not apply to Ultra disks.
 * @property burstingEnabledTime Latest time when bursting was last enabled on a disk.
 * @property completionPercent Percentage complete for the background copy when a resource is created via the CopyStart operation.
 * @property creationData Disk source information. CreationData information cannot be changed after the disk has been created.
 * @property dataAccessAuthMode Additional authentication requirements when exporting or uploading to a disk or snapshot.
 * @property diskAccessId ARM id of the DiskAccess resource for using private endpoints on disks.
 * @property diskIOPSReadOnly The total number of IOPS that will be allowed across all VMs mounting the shared disk as ReadOnly. One operation can transfer between 4k and 256k bytes.
 * @property diskIOPSReadWrite The number of IOPS allowed for this disk; only settable for UltraSSD disks. One operation can transfer between 4k and 256k bytes.
 * @property diskMBpsReadOnly The total throughput (MBps) that will be allowed across all VMs mounting the shared disk as ReadOnly. MBps means millions of bytes per second - MB here uses the ISO notation, of powers of 10.
 * @property diskMBpsReadWrite The bandwidth allowed for this disk; only settable for UltraSSD disks. MBps means millions of bytes per second - MB here uses the ISO notation, of powers of 10.
 * @property diskSizeBytes The size of the disk in bytes. This field is read only.
 * @property diskSizeGB If creationData.createOption is Empty, this field is mandatory and it indicates the size of the disk to create. If this field is present for updates or creation with other options, it indicates a resize. Resizes are only allowed if the disk is not attached to a running VM, and can only increase the disk's size.
 * @property diskState The state of the disk.
 * @property encryption Encryption property can be used to encrypt data at rest with customer managed keys or platform managed keys.
 * @property encryptionSettingsCollection Encryption settings collection used for Azure Disk Encryption, can contain multiple encryption settings per disk or snapshot.
 * @property extendedLocation The extended location where the disk will be created. Extended location cannot be changed.
 * @property hyperVGeneration The hypervisor generation of the Virtual Machine. Applicable to OS disks only.
 * @property id Resource Id
 * @property location Resource location
 * @property managedBy A relative URI containing the ID of the VM that has the disk attached.
 * @property managedByExtended List of relative URIs containing the IDs of the VMs that have the disk attached. maxShares should be set to a value greater than one for disks to allow attaching them to multiple VMs.
 * @property maxShares The maximum number of VMs that can attach to the disk at the same time. Value greater than one indicates a disk that can be mounted on multiple VMs at the same time.
 * @property name Resource name
 * @property networkAccessPolicy Policy for accessing the disk via network.
 * @property optimizedForFrequentAttach Setting this property to true improves reliability and performance of data disks that are frequently (more than 5 times a day) by detached from one virtual machine and attached to another. This property should not be set for disks that are not detached and attached frequently as it causes the disks to not align with the fault domain of the virtual machine.
 * @property osType The Operating System type.
 * @property propertyUpdatesInProgress Properties of the disk for which update is pending.
 * @property provisioningState The disk provisioning state.
 * @property publicNetworkAccess Policy for controlling export on the disk.
 * @property purchasePlan Purchase plan information for the the image from which the OS disk was created. E.g. - {name: 2019-Datacenter, publisher: MicrosoftWindowsServer, product: WindowsServer}
 * @property securityProfile Contains the security related information for the resource.
 * @property shareInfo Details of the list of all VMs that have the disk attached. maxShares should be set to a value greater than one for disks to allow attaching them to multiple VMs.
 * @property sku The disks sku name. Can be Standard_LRS, Premium_LRS, StandardSSD_LRS, UltraSSD_LRS, Premium_ZRS, StandardSSD_ZRS, or PremiumV2_LRS.
 * @property supportedCapabilities List of supported capabilities for the image from which the OS disk was created.
 * @property supportsHibernation Indicates the OS on a disk supports hibernation.
 * @property tags Resource tags
 * @property tier Performance tier of the disk (e.g, P4, S10) as described here: https://azure.microsoft.com/en-us/pricing/details/managed-disks/. Does not apply to Ultra disks.
 * @property timeCreated The time when the disk was created.
 * @property type Resource type
 * @property uniqueId Unique Guid identifying the resource.
 * @property zones The Logical zone list for Disk.
 */
public data class GetDiskResult(
    public val burstingEnabled: Boolean? = null,
    public val burstingEnabledTime: String,
    public val completionPercent: Double? = null,
    public val creationData: CreationDataResponse,
    public val dataAccessAuthMode: String? = null,
    public val diskAccessId: String? = null,
    public val diskIOPSReadOnly: Double? = null,
    public val diskIOPSReadWrite: Double? = null,
    public val diskMBpsReadOnly: Double? = null,
    public val diskMBpsReadWrite: Double? = null,
    public val diskSizeBytes: Double,
    public val diskSizeGB: Int? = null,
    public val diskState: String,
    public val encryption: EncryptionResponse? = null,
    public val encryptionSettingsCollection: EncryptionSettingsCollectionResponse? = null,
    public val extendedLocation: ExtendedLocationResponse? = null,
    public val hyperVGeneration: String? = null,
    public val id: String,
    public val location: String,
    public val managedBy: String,
    public val managedByExtended: List<String>,
    public val maxShares: Int? = null,
    public val name: String,
    public val networkAccessPolicy: String? = null,
    public val optimizedForFrequentAttach: Boolean? = null,
    public val osType: String? = null,
    public val propertyUpdatesInProgress: PropertyUpdatesInProgressResponse,
    public val provisioningState: String,
    public val publicNetworkAccess: String? = null,
    public val purchasePlan: PurchasePlanResponse? = null,
    public val securityProfile: DiskSecurityProfileResponse? = null,
    public val shareInfo: List<ShareInfoElementResponse>,
    public val sku: DiskSkuResponse? = null,
    public val supportedCapabilities: SupportedCapabilitiesResponse? = null,
    public val supportsHibernation: Boolean? = null,
    public val tags: Map<String, String>? = null,
    public val tier: String? = null,
    public val timeCreated: String,
    public val type: String,
    public val uniqueId: String,
    public val zones: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.GetDiskResult): GetDiskResult = GetDiskResult(
            burstingEnabled = javaType.burstingEnabled().map({ args0 -> args0 }).orElse(null),
            burstingEnabledTime = javaType.burstingEnabledTime(),
            completionPercent = javaType.completionPercent().map({ args0 -> args0 }).orElse(null),
            creationData = javaType.creationData().let({ args0 ->
                com.pulumi.azurenative.compute.kotlin.outputs.CreationDataResponse.Companion.toKotlin(args0)
            }),
            dataAccessAuthMode = javaType.dataAccessAuthMode().map({ args0 -> args0 }).orElse(null),
            diskAccessId = javaType.diskAccessId().map({ args0 -> args0 }).orElse(null),
            diskIOPSReadOnly = javaType.diskIOPSReadOnly().map({ args0 -> args0 }).orElse(null),
            diskIOPSReadWrite = javaType.diskIOPSReadWrite().map({ args0 -> args0 }).orElse(null),
            diskMBpsReadOnly = javaType.diskMBpsReadOnly().map({ args0 -> args0 }).orElse(null),
            diskMBpsReadWrite = javaType.diskMBpsReadWrite().map({ args0 -> args0 }).orElse(null),
            diskSizeBytes = javaType.diskSizeBytes(),
            diskSizeGB = javaType.diskSizeGB().map({ args0 -> args0 }).orElse(null),
            diskState = javaType.diskState(),
            encryption = javaType.encryption().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.EncryptionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            encryptionSettingsCollection = javaType.encryptionSettingsCollection().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.EncryptionSettingsCollectionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            extendedLocation = javaType.extendedLocation().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            hyperVGeneration = javaType.hyperVGeneration().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            location = javaType.location(),
            managedBy = javaType.managedBy(),
            managedByExtended = javaType.managedByExtended().map({ args0 -> args0 }),
            maxShares = javaType.maxShares().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            networkAccessPolicy = javaType.networkAccessPolicy().map({ args0 -> args0 }).orElse(null),
            optimizedForFrequentAttach = javaType.optimizedForFrequentAttach().map({ args0 ->
                args0
            }).orElse(null),
            osType = javaType.osType().map({ args0 -> args0 }).orElse(null),
            propertyUpdatesInProgress = javaType.propertyUpdatesInProgress().let({ args0 ->
                com.pulumi.azurenative.compute.kotlin.outputs.PropertyUpdatesInProgressResponse.Companion.toKotlin(args0)
            }),
            provisioningState = javaType.provisioningState(),
            publicNetworkAccess = javaType.publicNetworkAccess().map({ args0 -> args0 }).orElse(null),
            purchasePlan = javaType.purchasePlan().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.PurchasePlanResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            securityProfile = javaType.securityProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.DiskSecurityProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            shareInfo = javaType.shareInfo().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.ShareInfoElementResponse.Companion.toKotlin(args0)
                })
            }),
            sku = javaType.sku().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.DiskSkuResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            supportedCapabilities = javaType.supportedCapabilities().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.SupportedCapabilitiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            supportsHibernation = javaType.supportsHibernation().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            tier = javaType.tier().map({ args0 -> args0 }).orElse(null),
            timeCreated = javaType.timeCreated(),
            type = javaType.type(),
            uniqueId = javaType.uniqueId(),
            zones = javaType.zones().map({ args0 -> args0 }),
        )
    }
}
