@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Specifies information about the gallery Application Definition that you want to create or update.
 * @property customActions A list of custom actions that can be performed with all of the Gallery Application Versions within this Gallery Application.
 * @property description The description of this gallery Application Definition resource. This property is updatable.
 * @property endOfLifeDate The end of life date of the gallery Application Definition. This property can be used for decommissioning purposes. This property is updatable.
 * @property eula The Eula agreement for the gallery Application Definition.
 * @property id Resource Id
 * @property location Resource location
 * @property name Resource name
 * @property privacyStatementUri The privacy statement uri.
 * @property releaseNoteUri The release note uri.
 * @property supportedOSType This property allows you to specify the supported type of the OS that application is built for. <br><br> Possible values are: <br><br> **Windows** <br><br> **Linux**
 * @property tags Resource tags
 * @property type Resource type
 */
public data class GetGalleryApplicationResult(
    public val customActions: List<GalleryApplicationCustomActionResponse>? = null,
    public val description: String? = null,
    public val endOfLifeDate: String? = null,
    public val eula: String? = null,
    public val id: String,
    public val location: String,
    public val name: String,
    public val privacyStatementUri: String? = null,
    public val releaseNoteUri: String? = null,
    public val supportedOSType: String,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.GetGalleryApplicationResult): GetGalleryApplicationResult = GetGalleryApplicationResult(
            customActions = javaType.customActions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.GalleryApplicationCustomActionResponse.Companion.toKotlin(args0)
                })
            }),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            endOfLifeDate = javaType.endOfLifeDate().map({ args0 -> args0 }).orElse(null),
            eula = javaType.eula().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            privacyStatementUri = javaType.privacyStatementUri().map({ args0 -> args0 }).orElse(null),
            releaseNoteUri = javaType.releaseNoteUri().map({ args0 -> args0 }).orElse(null),
            supportedOSType = javaType.supportedOSType(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
