@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Specifies information about the proximity placement group.
 * @property availabilitySets A list of references to all availability sets in the proximity placement group.
 * @property colocationStatus Describes colocation status of the Proximity Placement Group.
 * @property id Resource Id
 * @property intent Specifies the user intent of the proximity placement group.
 * @property location Resource location
 * @property name Resource name
 * @property proximityPlacementGroupType Specifies the type of the proximity placement group. Possible values are: **Standard** : Co-locate resources within an Azure region or Availability Zone. **Ultra** : For future use.
 * @property tags Resource tags
 * @property type Resource type
 * @property virtualMachineScaleSets A list of references to all virtual machine scale sets in the proximity placement group.
 * @property virtualMachines A list of references to all virtual machines in the proximity placement group.
 * @property zones Specifies the Availability Zone where virtual machine, virtual machine scale set or availability set associated with the  proximity placement group can be created.
 */
public data class GetProximityPlacementGroupResult(
    public val availabilitySets: List<SubResourceWithColocationStatusResponse>,
    public val colocationStatus: InstanceViewStatusResponse? = null,
    public val id: String,
    public val intent: ProximityPlacementGroupPropertiesResponseIntent? = null,
    public val location: String,
    public val name: String,
    public val proximityPlacementGroupType: String? = null,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val virtualMachineScaleSets: List<SubResourceWithColocationStatusResponse>,
    public val virtualMachines: List<SubResourceWithColocationStatusResponse>,
    public val zones: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.GetProximityPlacementGroupResult): GetProximityPlacementGroupResult = GetProximityPlacementGroupResult(
            availabilitySets = javaType.availabilitySets().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.SubResourceWithColocationStatusResponse.Companion.toKotlin(args0)
                })
            }),
            colocationStatus = javaType.colocationStatus().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.InstanceViewStatusResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
            intent = javaType.intent().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.ProximityPlacementGroupPropertiesResponseIntent.Companion.toKotlin(args0)
                })
            }).orElse(null),
            location = javaType.location(),
            name = javaType.name(),
            proximityPlacementGroupType = javaType.proximityPlacementGroupType().map({ args0 ->
                args0
            }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            virtualMachineScaleSets = javaType.virtualMachineScaleSets().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.SubResourceWithColocationStatusResponse.Companion.toKotlin(args0)
                })
            }),
            virtualMachines = javaType.virtualMachines().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.SubResourceWithColocationStatusResponse.Companion.toKotlin(args0)
                })
            }),
            zones = javaType.zones().map({ args0 -> args0 }),
        )
    }
}
