@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Create or update Restore Point collection parameters.
 * @property id Resource Id
 * @property location Resource location
 * @property name Resource name
 * @property provisioningState The provisioning state of the restore point collection.
 * @property restorePointCollectionId The unique id of the restore point collection.
 * @property restorePoints A list containing all restore points created under this restore point collection.
 * @property source The properties of the source resource that this restore point collection is created from.
 * @property tags Resource tags
 * @property type Resource type
 */
public data class GetRestorePointCollectionResult(
    public val id: String,
    public val location: String,
    public val name: String,
    public val provisioningState: String,
    public val restorePointCollectionId: String,
    public val restorePoints: List<RestorePointResponse>,
    public val source: RestorePointCollectionSourcePropertiesResponse? = null,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.GetRestorePointCollectionResult): GetRestorePointCollectionResult = GetRestorePointCollectionResult(
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            restorePointCollectionId = javaType.restorePointCollectionId(),
            restorePoints = javaType.restorePoints().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.RestorePointResponse.Companion.toKotlin(args0)
                })
            }),
            source = javaType.source().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.RestorePointCollectionSourcePropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
