@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Snapshot resource.
 * @property completionPercent Percentage complete for the background copy when a resource is created via the CopyStart operation.
 * @property copyCompletionError Indicates the error details if the background copy of a resource created via the CopyStart operation fails.
 * @property creationData Disk source information. CreationData information cannot be changed after the disk has been created.
 * @property dataAccessAuthMode Additional authentication requirements when exporting or uploading to a disk or snapshot.
 * @property diskAccessId ARM id of the DiskAccess resource for using private endpoints on disks.
 * @property diskSizeBytes The size of the disk in bytes. This field is read only.
 * @property diskSizeGB If creationData.createOption is Empty, this field is mandatory and it indicates the size of the disk to create. If this field is present for updates or creation with other options, it indicates a resize. Resizes are only allowed if the disk is not attached to a running VM, and can only increase the disk's size.
 * @property diskState The state of the snapshot.
 * @property encryption Encryption property can be used to encrypt data at rest with customer managed keys or platform managed keys.
 * @property encryptionSettingsCollection Encryption settings collection used be Azure Disk Encryption, can contain multiple encryption settings per disk or snapshot.
 * @property extendedLocation The extended location where the snapshot will be created. Extended location cannot be changed.
 * @property hyperVGeneration The hypervisor generation of the Virtual Machine. Applicable to OS disks only.
 * @property id Resource Id
 * @property incremental Whether a snapshot is incremental. Incremental snapshots on the same disk occupy less space than full snapshots and can be diffed.
 * @property incrementalSnapshotFamilyId Incremental snapshots for a disk share an incremental snapshot family id. The Get Page Range Diff API can only be called on incremental snapshots with the same family id.
 * @property location Resource location
 * @property managedBy Unused. Always Null.
 * @property name Resource name
 * @property networkAccessPolicy Policy for accessing the disk via network.
 * @property osType The Operating System type.
 * @property provisioningState The disk provisioning state.
 * @property publicNetworkAccess Policy for controlling export on the disk.
 * @property purchasePlan Purchase plan information for the image from which the source disk for the snapshot was originally created.
 * @property securityProfile Contains the security related information for the resource.
 * @property sku The snapshots sku name. Can be Standard_LRS, Premium_LRS, or Standard_ZRS. This is an optional parameter for incremental snapshot and the default behavior is the SKU will be set to the same sku as the previous snapshot
 * @property supportedCapabilities List of supported capabilities for the image from which the source disk from the snapshot was originally created.
 * @property supportsHibernation Indicates the OS on a snapshot supports hibernation.
 * @property tags Resource tags
 * @property timeCreated The time when the snapshot was created.
 * @property type Resource type
 * @property uniqueId Unique Guid identifying the resource.
 */
public data class GetSnapshotResult(
    public val completionPercent: Double? = null,
    public val copyCompletionError: CopyCompletionErrorResponse? = null,
    public val creationData: CreationDataResponse,
    public val dataAccessAuthMode: String? = null,
    public val diskAccessId: String? = null,
    public val diskSizeBytes: Double,
    public val diskSizeGB: Int? = null,
    public val diskState: String,
    public val encryption: EncryptionResponse? = null,
    public val encryptionSettingsCollection: EncryptionSettingsCollectionResponse? = null,
    public val extendedLocation: ExtendedLocationResponse? = null,
    public val hyperVGeneration: String? = null,
    public val id: String,
    public val incremental: Boolean? = null,
    public val incrementalSnapshotFamilyId: String,
    public val location: String,
    public val managedBy: String,
    public val name: String,
    public val networkAccessPolicy: String? = null,
    public val osType: String? = null,
    public val provisioningState: String,
    public val publicNetworkAccess: String? = null,
    public val purchasePlan: PurchasePlanResponse? = null,
    public val securityProfile: DiskSecurityProfileResponse? = null,
    public val sku: SnapshotSkuResponse? = null,
    public val supportedCapabilities: SupportedCapabilitiesResponse? = null,
    public val supportsHibernation: Boolean? = null,
    public val tags: Map<String, String>? = null,
    public val timeCreated: String,
    public val type: String,
    public val uniqueId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.GetSnapshotResult): GetSnapshotResult = GetSnapshotResult(
            completionPercent = javaType.completionPercent().map({ args0 -> args0 }).orElse(null),
            copyCompletionError = javaType.copyCompletionError().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.CopyCompletionErrorResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            creationData = javaType.creationData().let({ args0 ->
                com.pulumi.azurenative.compute.kotlin.outputs.CreationDataResponse.Companion.toKotlin(args0)
            }),
            dataAccessAuthMode = javaType.dataAccessAuthMode().map({ args0 -> args0 }).orElse(null),
            diskAccessId = javaType.diskAccessId().map({ args0 -> args0 }).orElse(null),
            diskSizeBytes = javaType.diskSizeBytes(),
            diskSizeGB = javaType.diskSizeGB().map({ args0 -> args0 }).orElse(null),
            diskState = javaType.diskState(),
            encryption = javaType.encryption().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.EncryptionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            encryptionSettingsCollection = javaType.encryptionSettingsCollection().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.EncryptionSettingsCollectionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            extendedLocation = javaType.extendedLocation().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            hyperVGeneration = javaType.hyperVGeneration().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            incremental = javaType.incremental().map({ args0 -> args0 }).orElse(null),
            incrementalSnapshotFamilyId = javaType.incrementalSnapshotFamilyId(),
            location = javaType.location(),
            managedBy = javaType.managedBy(),
            name = javaType.name(),
            networkAccessPolicy = javaType.networkAccessPolicy().map({ args0 -> args0 }).orElse(null),
            osType = javaType.osType().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            publicNetworkAccess = javaType.publicNetworkAccess().map({ args0 -> args0 }).orElse(null),
            purchasePlan = javaType.purchasePlan().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.PurchasePlanResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            securityProfile = javaType.securityProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.DiskSecurityProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            sku = javaType.sku().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.SnapshotSkuResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            supportedCapabilities = javaType.supportedCapabilities().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.SupportedCapabilitiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            supportsHibernation = javaType.supportsHibernation().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            timeCreated = javaType.timeCreated(),
            type = javaType.type(),
            uniqueId = javaType.uniqueId(),
        )
    }
}
