@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Describes a Virtual Machine Scale Set Extension.
 * @property autoUpgradeMinorVersion Indicates whether the extension should use a newer minor version if one is available at deployment time. Once deployed, however, the extension will not upgrade minor versions unless redeployed, even with this property set to true.
 * @property enableAutomaticUpgrade Indicates whether the extension should be automatically upgraded by the platform if there is a newer version of the extension available.
 * @property forceUpdateTag If a value is provided and is different from the previous value, the extension handler will be forced to update even if the extension configuration has not changed.
 * @property id Resource Id
 * @property name The name of the extension.
 * @property protectedSettings The extension can contain either protectedSettings or protectedSettingsFromKeyVault or no protected settings at all.
 * @property protectedSettingsFromKeyVault The extensions protected settings that are passed by reference, and consumed from key vault
 * @property provisionAfterExtensions Collection of extension names after which this extension needs to be provisioned.
 * @property provisioningState The provisioning state, which only appears in the response.
 * @property publisher The name of the extension handler publisher.
 * @property settings Json formatted public settings for the extension.
 * @property suppressFailures Indicates whether failures stemming from the extension will be suppressed (Operational failures such as not connecting to the VM will not be suppressed regardless of this value). The default is false.
 * @property type Resource type
 * @property typeHandlerVersion Specifies the version of the script handler.
 */
public data class GetVirtualMachineScaleSetExtensionResult(
    public val autoUpgradeMinorVersion: Boolean? = null,
    public val enableAutomaticUpgrade: Boolean? = null,
    public val forceUpdateTag: String? = null,
    public val id: String,
    public val name: String? = null,
    public val protectedSettings: Any? = null,
    public val protectedSettingsFromKeyVault: KeyVaultSecretReferenceResponse? = null,
    public val provisionAfterExtensions: List<String>? = null,
    public val provisioningState: String,
    public val publisher: String? = null,
    public val settings: Any? = null,
    public val suppressFailures: Boolean? = null,
    public val type: String,
    public val typeHandlerVersion: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.GetVirtualMachineScaleSetExtensionResult): GetVirtualMachineScaleSetExtensionResult = GetVirtualMachineScaleSetExtensionResult(
            autoUpgradeMinorVersion = javaType.autoUpgradeMinorVersion().map({ args0 -> args0 }).orElse(null),
            enableAutomaticUpgrade = javaType.enableAutomaticUpgrade().map({ args0 -> args0 }).orElse(null),
            forceUpdateTag = javaType.forceUpdateTag().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            protectedSettings = javaType.protectedSettings().map({ args0 -> args0 }).orElse(null),
            protectedSettingsFromKeyVault = javaType.protectedSettingsFromKeyVault().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.KeyVaultSecretReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            provisionAfterExtensions = javaType.provisionAfterExtensions().map({ args0 -> args0 }),
            provisioningState = javaType.provisioningState(),
            publisher = javaType.publisher().map({ args0 -> args0 }).orElse(null),
            settings = javaType.settings().map({ args0 -> args0 }).orElse(null),
            suppressFailures = javaType.suppressFailures().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            typeHandlerVersion = javaType.typeHandlerVersion().map({ args0 -> args0 }).orElse(null),
        )
    }
}
