@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Describes a Virtual Machine Scale Set.
 * @property additionalCapabilities Specifies additional capabilities enabled or disabled on the Virtual Machines in the Virtual Machine Scale Set. For instance: whether the Virtual Machines have the capability to support attaching managed data disks with UltraSSD_LRS storage account type.
 * @property automaticRepairsPolicy Policy for automatic repairs.
 * @property constrainedMaximumCapacity Optional property which must either be set to True or omitted.
 * @property doNotRunExtensionsOnOverprovisionedVMs When Overprovision is enabled, extensions are launched only on the requested number of VMs which are finally kept. This property will hence ensure that the extensions do not run on the extra overprovisioned VMs.
 * @property extendedLocation The extended location of the Virtual Machine Scale Set.
 * @property hostGroup Specifies information about the dedicated host group that the virtual machine scale set resides in. Minimum api-version: 2020-06-01.
 * @property id Resource Id
 * @property identity The identity of the virtual machine scale set, if configured.
 * @property location Resource location
 * @property name Resource name
 * @property orchestrationMode Specifies the orchestration mode for the virtual machine scale set.
 * @property overprovision Specifies whether the Virtual Machine Scale Set should be overprovisioned.
 * @property plan Specifies information about the marketplace image used to create the virtual machine. This element is only used for marketplace images. Before you can use a marketplace image from an API, you must enable the image for programmatic use.  In the Azure portal, find the marketplace image that you want to use and then click **Want to deploy programmatically, Get Started ->**. Enter any required information and then click **Save**.
 * @property platformFaultDomainCount Fault Domain count for each placement group.
 * @property priorityMixPolicy Specifies the desired targets for mixing Spot and Regular priority VMs within the same VMSS Flex instance.
 * @property provisioningState The provisioning state, which only appears in the response.
 * @property proximityPlacementGroup Specifies information about the proximity placement group that the virtual machine scale set should be assigned to. Minimum api-version: 2018-04-01.
 * @property scaleInPolicy Specifies the policies applied when scaling in Virtual Machines in the Virtual Machine Scale Set.
 * @property singlePlacementGroup When true this limits the scale set to a single placement group, of max size 100 virtual machines. NOTE: If singlePlacementGroup is true, it may be modified to false. However, if singlePlacementGroup is false, it may not be modified to true.
 * @property sku The virtual machine scale set sku.
 * @property spotRestorePolicy Specifies the Spot Restore properties for the virtual machine scale set.
 * @property tags Resource tags
 * @property timeCreated Specifies the time at which the Virtual Machine Scale Set resource was created. Minimum api-version: 2021-11-01.
 * @property type Resource type
 * @property uniqueId Specifies the ID which uniquely identifies a Virtual Machine Scale Set.
 * @property upgradePolicy The upgrade policy.
 * @property virtualMachineProfile The virtual machine profile.
 * @property zoneBalance Whether to force strictly even Virtual Machine distribution cross x-zones in case there is zone outage. zoneBalance property can only be set if the zones property of the scale set contains more than one zone. If there are no zones or only one zone specified, then zoneBalance property should not be set.
 * @property zones The virtual machine scale set zones. NOTE: Availability zones can only be set when you create the scale set
 */
public data class GetVirtualMachineScaleSetResult(
    public val additionalCapabilities: AdditionalCapabilitiesResponse? = null,
    public val automaticRepairsPolicy: AutomaticRepairsPolicyResponse? = null,
    public val constrainedMaximumCapacity: Boolean? = null,
    public val doNotRunExtensionsOnOverprovisionedVMs: Boolean? = null,
    public val extendedLocation: ExtendedLocationResponse? = null,
    public val hostGroup: SubResourceResponse? = null,
    public val id: String,
    public val identity: VirtualMachineScaleSetIdentityResponse? = null,
    public val location: String,
    public val name: String,
    public val orchestrationMode: String? = null,
    public val overprovision: Boolean? = null,
    public val plan: PlanResponse? = null,
    public val platformFaultDomainCount: Int? = null,
    public val priorityMixPolicy: PriorityMixPolicyResponse? = null,
    public val provisioningState: String,
    public val proximityPlacementGroup: SubResourceResponse? = null,
    public val scaleInPolicy: ScaleInPolicyResponse? = null,
    public val singlePlacementGroup: Boolean? = null,
    public val sku: SkuResponse? = null,
    public val spotRestorePolicy: SpotRestorePolicyResponse? = null,
    public val tags: Map<String, String>? = null,
    public val timeCreated: String,
    public val type: String,
    public val uniqueId: String,
    public val upgradePolicy: UpgradePolicyResponse? = null,
    public val virtualMachineProfile: VirtualMachineScaleSetVMProfileResponse? = null,
    public val zoneBalance: Boolean? = null,
    public val zones: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.GetVirtualMachineScaleSetResult): GetVirtualMachineScaleSetResult = GetVirtualMachineScaleSetResult(
            additionalCapabilities = javaType.additionalCapabilities().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.AdditionalCapabilitiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            automaticRepairsPolicy = javaType.automaticRepairsPolicy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.AutomaticRepairsPolicyResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            constrainedMaximumCapacity = javaType.constrainedMaximumCapacity().map({ args0 ->
                args0
            }).orElse(null),
            doNotRunExtensionsOnOverprovisionedVMs = javaType.doNotRunExtensionsOnOverprovisionedVMs().map({ args0 ->
                args0
            }).orElse(null),
            extendedLocation = javaType.extendedLocation().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            hostGroup = javaType.hostGroup().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.VirtualMachineScaleSetIdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            location = javaType.location(),
            name = javaType.name(),
            orchestrationMode = javaType.orchestrationMode().map({ args0 -> args0 }).orElse(null),
            overprovision = javaType.overprovision().map({ args0 -> args0 }).orElse(null),
            plan = javaType.plan().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.PlanResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            platformFaultDomainCount = javaType.platformFaultDomainCount().map({ args0 -> args0 }).orElse(null),
            priorityMixPolicy = javaType.priorityMixPolicy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.PriorityMixPolicyResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            provisioningState = javaType.provisioningState(),
            proximityPlacementGroup = javaType.proximityPlacementGroup().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            scaleInPolicy = javaType.scaleInPolicy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.ScaleInPolicyResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            singlePlacementGroup = javaType.singlePlacementGroup().map({ args0 -> args0 }).orElse(null),
            sku = javaType.sku().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.SkuResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            spotRestorePolicy = javaType.spotRestorePolicy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.SpotRestorePolicyResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            timeCreated = javaType.timeCreated(),
            type = javaType.type(),
            uniqueId = javaType.uniqueId(),
            upgradePolicy = javaType.upgradePolicy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.UpgradePolicyResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            virtualMachineProfile = javaType.virtualMachineProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.VirtualMachineScaleSetVMProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            zoneBalance = javaType.zoneBalance().map({ args0 -> args0 }).orElse(null),
            zones = javaType.zones().map({ args0 -> args0 }),
        )
    }
}
