@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Specifies the hardware settings for the virtual machine.
 * @property vmSize Specifies the size of the virtual machine. The enum data type is currently deprecated and will be removed by December 23rd 2023. The recommended way to get the list of available sizes is using these APIs: [List all available virtual machine sizes in an availability set](https://docs&#46;microsoft&#46;com/rest/api/compute/availabilitysets/listavailablesizes), [List all available virtual machine sizes in a region]( https://docs&#46;microsoft&#46;com/rest/api/compute/resourceskus/list), [List all available virtual machine sizes for resizing](https://docs&#46;microsoft&#46;com/rest/api/compute/virtualmachines/listavailablesizes)&#46; For more information about virtual machine sizes, see [Sizes for virtual machines](https://docs.microsoft.com/azure/virtual-machines/sizes). The available VM sizes depend on region and availability set.
 * @property vmSizeProperties Specifies the properties for customizing the size of the virtual machine. Minimum api-version: 2021-07-01. This feature is still in preview mode and is not supported for VirtualMachineScaleSet. Please follow the instructions in [VM Customization](https://aka.ms/vmcustomization) for more details.
 */
public data class HardwareProfileResponse(
    public val vmSize: String? = null,
    public val vmSizeProperties: VMSizePropertiesResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.HardwareProfileResponse): HardwareProfileResponse = HardwareProfileResponse(
            vmSize = javaType.vmSize().map({ args0 -> args0 }).orElse(null),
            vmSizeProperties = javaType.vmSizeProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.VMSizePropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
