@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Describes the gallery image definition purchase plan. This is used by marketplace images.
 * @property name The plan ID.
 * @property product The product ID.
 * @property publisher The publisher ID.
 */
public data class ImagePurchasePlanResponse(
    public val name: String? = null,
    public val product: String? = null,
    public val publisher: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.ImagePurchasePlanResponse): ImagePurchasePlanResponse = ImagePurchasePlanResponse(
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            product = javaType.product().map({ args0 -> args0 }).orElse(null),
            publisher = javaType.publisher().map({ args0 -> args0 }).orElse(null),
        )
    }
}
