@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Inner error details.
 * @property errordetail The internal error message or exception dump.
 * @property exceptiontype The exception type.
 */
public data class InnerErrorResponse(
    public val errordetail: String? = null,
    public val exceptiontype: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.InnerErrorResponse): InnerErrorResponse = InnerErrorResponse(
            errordetail = javaType.errordetail().map({ args0 -> args0 }).orElse(null),
            exceptiontype = javaType.exceptiontype().map({ args0 -> args0 }).orElse(null),
        )
    }
}
