@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Key Vault Key Url to be used for server side encryption of Managed Disks and Snapshots
 * @property keyUrl Fully versioned Key Url pointing to a key in KeyVault. Version segment of the Url is required regardless of rotationToLatestKeyVersionEnabled value.
 * @property sourceVault Resource id of the KeyVault containing the key or secret. This property is optional and cannot be used if the KeyVault subscription is not the same as the Disk Encryption Set subscription.
 */
public data class KeyForDiskEncryptionSetResponse(
    public val keyUrl: String,
    public val sourceVault: SourceVaultResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.KeyForDiskEncryptionSetResponse): KeyForDiskEncryptionSetResponse = KeyForDiskEncryptionSetResponse(
            keyUrl = javaType.keyUrl(),
            sourceVault = javaType.sourceVault().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.SourceVaultResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
