@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Key Vault Secret Url and vault id of the encryption key
 * @property secretUrl Url pointing to a key or secret in KeyVault
 * @property sourceVault Resource id of the KeyVault containing the key or secret
 */
public data class KeyVaultAndSecretReferenceResponse(
    public val secretUrl: String,
    public val sourceVault: SourceVaultResponse,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.KeyVaultAndSecretReferenceResponse): KeyVaultAndSecretReferenceResponse = KeyVaultAndSecretReferenceResponse(
            secretUrl = javaType.secretUrl(),
            sourceVault = javaType.sourceVault().let({ args0 ->
                com.pulumi.azurenative.compute.kotlin.outputs.SourceVaultResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
