@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Describes a reference to Key Vault Key
 * @property keyUrl The URL referencing a key encryption key in Key Vault.
 * @property sourceVault The relative URL of the Key Vault containing the key.
 */
public data class KeyVaultKeyReferenceResponse(
    public val keyUrl: String,
    public val sourceVault: SubResourceResponse,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.KeyVaultKeyReferenceResponse): KeyVaultKeyReferenceResponse = KeyVaultKeyReferenceResponse(
            keyUrl = javaType.keyUrl(),
            sourceVault = javaType.sourceVault().let({ args0 ->
                com.pulumi.azurenative.compute.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
