@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Describes a reference to Key Vault Secret
 * @property secretUrl The URL referencing a secret in a Key Vault.
 * @property sourceVault The relative URL of the Key Vault containing the secret.
 */
public data class KeyVaultSecretReferenceResponse(
    public val secretUrl: String,
    public val sourceVault: SubResourceResponse,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.KeyVaultSecretReferenceResponse): KeyVaultSecretReferenceResponse = KeyVaultSecretReferenceResponse(
            secretUrl = javaType.secretUrl(),
            sourceVault = javaType.sourceVault().let({ args0 ->
                com.pulumi.azurenative.compute.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
