@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 * Specifies the Linux operating system settings on the virtual machine. For a list of supported Linux distributions, see [Linux on Azure-Endorsed Distributions](https://docs.microsoft.com/azure/virtual-machines/linux/endorsed-distros).
 * @property disablePasswordAuthentication Specifies whether password authentication should be disabled.
 * @property enableVMAgentPlatformUpdates Indicates whether VMAgent Platform Updates is enabled for the Linux virtual machine. Default value is false.
 * @property patchSettings [Preview Feature] Specifies settings related to VM Guest Patching on Linux.
 * @property provisionVMAgent Indicates whether virtual machine agent should be provisioned on the virtual machine. When this property is not specified in the request body, default behavior is to set it to true. This will ensure that VM Agent is installed on the VM so that extensions can be added to the VM later.
 * @property ssh Specifies the ssh key configuration for a Linux OS.
 */
public data class LinuxConfigurationResponse(
    public val disablePasswordAuthentication: Boolean? = null,
    public val enableVMAgentPlatformUpdates: Boolean? = null,
    public val patchSettings: LinuxPatchSettingsResponse? = null,
    public val provisionVMAgent: Boolean? = null,
    public val ssh: SshConfigurationResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.LinuxConfigurationResponse): LinuxConfigurationResponse = LinuxConfigurationResponse(
            disablePasswordAuthentication = javaType.disablePasswordAuthentication().map({ args0 ->
                args0
            }).orElse(null),
            enableVMAgentPlatformUpdates = javaType.enableVMAgentPlatformUpdates().map({ args0 ->
                args0
            }).orElse(null),
            patchSettings = javaType.patchSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.LinuxPatchSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            provisionVMAgent = javaType.provisionVMAgent().map({ args0 -> args0 }).orElse(null),
            ssh = javaType.ssh().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.SshConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
