@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * Describes the properties of the load balancer configuration.
 * @property frontendIpConfigurations Specifies the frontend IP to be used for the load balancer. Only IPv4 frontend IP address is supported. Each load balancer configuration must have exactly one frontend IP configuration.
 */
public data class LoadBalancerConfigurationPropertiesResponse(
    public val frontendIpConfigurations: List<LoadBalancerFrontendIpConfigurationResponse>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.LoadBalancerConfigurationPropertiesResponse): LoadBalancerConfigurationPropertiesResponse = LoadBalancerConfigurationPropertiesResponse(
            frontendIpConfigurations = javaType.frontendIpConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.LoadBalancerFrontendIpConfigurationResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
