@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Describes a cloud service IP Configuration
 * @property privateIPAddress The virtual network private IP address of the IP configuration.
 * @property publicIPAddress The reference to the public ip address resource.
 * @property subnet The reference to the virtual network subnet resource.
 */
public data class LoadBalancerFrontendIpConfigurationPropertiesResponse(
    public val privateIPAddress: String? = null,
    public val publicIPAddress: SubResourceResponse? = null,
    public val subnet: SubResourceResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.LoadBalancerFrontendIpConfigurationPropertiesResponse): LoadBalancerFrontendIpConfigurationPropertiesResponse =
            LoadBalancerFrontendIpConfigurationPropertiesResponse(
                privateIPAddress = javaType.privateIPAddress().map({ args0 -> args0 }).orElse(null),
                publicIPAddress = javaType.publicIPAddress().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.compute.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                subnet = javaType.subnet().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.compute.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
