@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Specifies the frontend IP to be used for the load balancer. Only IPv4 frontend IP address is supported. Each load balancer configuration must have exactly one frontend IP configuration.
 * @property name The name of the resource that is unique within the set of frontend IP configurations used by the load balancer. This name can be used to access the resource.
 * @property properties Properties of load balancer frontend ip configuration.
 */
public data class LoadBalancerFrontendIpConfigurationResponse(
    public val name: String,
    public val properties: LoadBalancerFrontendIpConfigurationPropertiesResponse,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.LoadBalancerFrontendIpConfigurationResponse): LoadBalancerFrontendIpConfigurationResponse = LoadBalancerFrontendIpConfigurationResponse(
            name = javaType.name(),
            properties = javaType.properties().let({ args0 ->
                com.pulumi.azurenative.compute.kotlin.outputs.LoadBalancerFrontendIpConfigurationPropertiesResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
