@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Maintenance Operation Status.
 * @property isCustomerInitiatedMaintenanceAllowed True, if customer is allowed to perform Maintenance.
 * @property lastOperationMessage Message returned for the last Maintenance Operation.
 * @property lastOperationResultCode The Last Maintenance Operation Result Code.
 * @property maintenanceWindowEndTime End Time for the Maintenance Window.
 * @property maintenanceWindowStartTime Start Time for the Maintenance Window.
 * @property preMaintenanceWindowEndTime End Time for the Pre Maintenance Window.
 * @property preMaintenanceWindowStartTime Start Time for the Pre Maintenance Window.
 */
public data class MaintenanceRedeployStatusResponse(
    public val isCustomerInitiatedMaintenanceAllowed: Boolean? = null,
    public val lastOperationMessage: String? = null,
    public val lastOperationResultCode: String? = null,
    public val maintenanceWindowEndTime: String? = null,
    public val maintenanceWindowStartTime: String? = null,
    public val preMaintenanceWindowEndTime: String? = null,
    public val preMaintenanceWindowStartTime: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.MaintenanceRedeployStatusResponse): MaintenanceRedeployStatusResponse = MaintenanceRedeployStatusResponse(
            isCustomerInitiatedMaintenanceAllowed = javaType.isCustomerInitiatedMaintenanceAllowed().map({ args0 ->
                args0
            }).orElse(null),
            lastOperationMessage = javaType.lastOperationMessage().map({ args0 -> args0 }).orElse(null),
            lastOperationResultCode = javaType.lastOperationResultCode().map({ args0 -> args0 }).orElse(null),
            maintenanceWindowEndTime = javaType.maintenanceWindowEndTime().map({ args0 -> args0 }).orElse(null),
            maintenanceWindowStartTime = javaType.maintenanceWindowStartTime().map({ args0 ->
                args0
            }).orElse(null),
            preMaintenanceWindowEndTime = javaType.preMaintenanceWindowEndTime().map({ args0 ->
                args0
            }).orElse(null),
            preMaintenanceWindowStartTime = javaType.preMaintenanceWindowStartTime().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
