@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Contains encryption settings for an OS disk image.
 * @property diskEncryptionSetId A relative URI containing the resource ID of the disk encryption set.
 * @property securityProfile This property specifies the security profile of an OS disk image.
 */
public data class OSDiskImageEncryptionResponse(
    public val diskEncryptionSetId: String? = null,
    public val securityProfile: OSDiskImageSecurityProfileResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.OSDiskImageEncryptionResponse): OSDiskImageEncryptionResponse = OSDiskImageEncryptionResponse(
            diskEncryptionSetId = javaType.diskEncryptionSetId().map({ args0 -> args0 }).orElse(null),
            securityProfile = javaType.securityProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.OSDiskImageSecurityProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
