@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Specifies information about the operating system disk used by the virtual machine. For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview).
 * @property caching Specifies the caching requirements. Possible values are: **None,** **ReadOnly,** **ReadWrite.** The defaulting behavior is: **None for Standard storage. ReadOnly for Premium storage.**
 * @property createOption Specifies how the virtual machine should be created. Possible values are: **Attach.** This value is used when you are using a specialized disk to create the virtual machine. **FromImage.** This value is used when you are using an image to create the virtual machine. If you are using a platform image, you should also use the imageReference element described above. If you are using a marketplace image, you should also use the plan element previously described.
 * @property deleteOption Specifies whether OS Disk should be deleted or detached upon VM deletion. Possible values are: **Delete.** If this value is used, the OS disk is deleted when VM is deleted. **Detach.** If this value is used, the os disk is retained after VM is deleted. The default value is set to **Detach**. For an ephemeral OS Disk, the default value is set to **Delete**. The user cannot change the delete option for an ephemeral OS Disk.
 * @property diffDiskSettings Specifies the ephemeral Disk Settings for the operating system disk used by the virtual machine.
 * @property diskSizeGB Specifies the size of an empty data disk in gigabytes. This element can be used to overwrite the size of the disk in a virtual machine image. The property 'diskSizeGB' is the number of bytes x 1024^3 for the disk and the value cannot be larger than 1023.
 * @property encryptionSettings Specifies the encryption settings for the OS Disk. Minimum api-version: 2015-06-15.
 * @property image The source user image virtual hard disk. The virtual hard disk will be copied before being attached to the virtual machine. If SourceImage is provided, the destination virtual hard drive must not exist.
 * @property managedDisk The managed disk parameters.
 * @property name The disk name.
 * @property osType This property allows you to specify the type of the OS that is included in the disk if creating a VM from user-image or a specialized VHD. Possible values are: **Windows,** **Linux.**
 * @property vhd The virtual hard disk.
 * @property writeAcceleratorEnabled Specifies whether writeAccelerator should be enabled or disabled on the disk.
 */
public data class OSDiskResponse(
    public val caching: String? = null,
    public val createOption: String,
    public val deleteOption: String? = null,
    public val diffDiskSettings: DiffDiskSettingsResponse? = null,
    public val diskSizeGB: Int? = null,
    public val encryptionSettings: DiskEncryptionSettingsResponse? = null,
    public val image: VirtualHardDiskResponse? = null,
    public val managedDisk: ManagedDiskParametersResponse? = null,
    public val name: String? = null,
    public val osType: String? = null,
    public val vhd: VirtualHardDiskResponse? = null,
    public val writeAcceleratorEnabled: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.OSDiskResponse): OSDiskResponse = OSDiskResponse(
            caching = javaType.caching().map({ args0 -> args0 }).orElse(null),
            createOption = javaType.createOption(),
            deleteOption = javaType.deleteOption().map({ args0 -> args0 }).orElse(null),
            diffDiskSettings = javaType.diffDiskSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.DiffDiskSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            diskSizeGB = javaType.diskSizeGB().map({ args0 -> args0 }).orElse(null),
            encryptionSettings = javaType.encryptionSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.DiskEncryptionSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            image = javaType.image().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.VirtualHardDiskResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            managedDisk = javaType.managedDisk().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.ManagedDiskParametersResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            osType = javaType.osType().map({ args0 -> args0 }).orElse(null),
            vhd = javaType.vhd().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.VirtualHardDiskResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            writeAcceleratorEnabled = javaType.writeAcceleratorEnabled().map({ args0 -> args0 }).orElse(null),
        )
    }
}
