@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Specifies settings related to VM Guest Patching on Windows.
 * @property assessmentMode Specifies the mode of VM Guest patch assessment for the IaaS virtual machine.<br /><br /> Possible values are:<br /><br /> **ImageDefault** - You control the timing of patch assessments on a virtual machine.<br /><br /> **AutomaticByPlatform** - The platform will trigger periodic patch assessments. The property provisionVMAgent must be true.
 * @property automaticByPlatformSettings Specifies additional settings for patch mode AutomaticByPlatform in VM Guest Patching on Windows.
 * @property enableHotpatching Enables customers to patch their Azure VMs without requiring a reboot. For enableHotpatching, the 'provisionVMAgent' must be set to true and 'patchMode' must be set to 'AutomaticByPlatform'.
 * @property patchMode Specifies the mode of VM Guest Patching to IaaS virtual machine or virtual machines associated to virtual machine scale set with OrchestrationMode as Flexible.<br /><br /> Possible values are:<br /><br /> **Manual** - You  control the application of patches to a virtual machine. You do this by applying patches manually inside the VM. In this mode, automatic updates are disabled; the property WindowsConfiguration.enableAutomaticUpdates must be false<br /><br /> **AutomaticByOS** - The virtual machine will automatically be updated by the OS. The property WindowsConfiguration.enableAutomaticUpdates must be true. <br /><br /> **AutomaticByPlatform** - the virtual machine will automatically updated by the platform. The properties provisionVMAgent and WindowsConfiguration.enableAutomaticUpdates must be true
 */
public data class PatchSettingsResponse(
    public val assessmentMode: String? = null,
    public val automaticByPlatformSettings: WindowsVMGuestPatchAutomaticByPlatformSettingsResponse? =
        null,
    public val enableHotpatching: Boolean? = null,
    public val patchMode: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.PatchSettingsResponse): PatchSettingsResponse = PatchSettingsResponse(
            assessmentMode = javaType.assessmentMode().map({ args0 -> args0 }).orElse(null),
            automaticByPlatformSettings = javaType.automaticByPlatformSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.WindowsVMGuestPatchAutomaticByPlatformSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            enableHotpatching = javaType.enableHotpatching().map({ args0 -> args0 }).orElse(null),
            patchMode = javaType.patchMode().map({ args0 -> args0 }).orElse(null),
        )
    }
}
