@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Specifies information about the marketplace image used to create the virtual machine. This element is only used for marketplace images. Before you can use a marketplace image from an API, you must enable the image for programmatic use.  In the Azure portal, find the marketplace image that you want to use and then click **Want to deploy programmatically, Get Started ->**. Enter any required information and then click **Save**.
 * @property name The plan ID.
 * @property product Specifies the product of the image from the marketplace. This is the same value as Offer under the imageReference element.
 * @property promotionCode The promotion code.
 * @property publisher The publisher ID.
 */
public data class PlanResponse(
    public val name: String? = null,
    public val product: String? = null,
    public val promotionCode: String? = null,
    public val publisher: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.PlanResponse): PlanResponse = PlanResponse(
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            product = javaType.product().map({ args0 -> args0 }).orElse(null),
            promotionCode = javaType.promotionCode().map({ args0 -> args0 }).orElse(null),
            publisher = javaType.publisher().map({ args0 -> args0 }).orElse(null),
        )
    }
}
