@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 * Specifies the target splits for Spot and Regular priority VMs within a scale set with flexible orchestration mode. With this property the customer is able to specify the base number of regular priority VMs created as the VMSS flex instance scales out and the split between Spot and Regular priority VMs after this base target has been reached.
 * @property baseRegularPriorityCount The base number of regular priority VMs that will be created in this scale set as it scales out.
 * @property regularPriorityPercentageAboveBase The percentage of VM instances, after the base regular priority count has been reached, that are expected to use regular priority.
 */
public data class PriorityMixPolicyResponse(
    public val baseRegularPriorityCount: Int? = null,
    public val regularPriorityPercentageAboveBase: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.PriorityMixPolicyResponse): PriorityMixPolicyResponse = PriorityMixPolicyResponse(
            baseRegularPriorityCount = javaType.baseRegularPriorityCount().map({ args0 -> args0 }).orElse(null),
            regularPriorityPercentageAboveBase = javaType.regularPriorityPercentageAboveBase().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
