@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Specifies the user intent of the proximity placement group.
 * @property vmSizes Specifies possible sizes of virtual machines that can be created in the proximity placement group.
 */
public data class ProximityPlacementGroupPropertiesResponseIntent(
    public val vmSizes: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.ProximityPlacementGroupPropertiesResponseIntent): ProximityPlacementGroupPropertiesResponseIntent =
            ProximityPlacementGroupPropertiesResponseIntent(
                vmSizes = javaType.vmSizes().map({ args0 -> args0 }),
            )
    }
}
