@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Used for establishing the purchase context of any 3rd Party artifact through MarketPlace.
 * @property name The plan ID.
 * @property product Specifies the product of the image from the marketplace. This is the same value as Offer under the imageReference element.
 * @property promotionCode The Offer Promotion Code.
 * @property publisher The publisher ID.
 */
public data class PurchasePlanResponse(
    public val name: String,
    public val product: String,
    public val promotionCode: String? = null,
    public val publisher: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.PurchasePlanResponse): PurchasePlanResponse = PurchasePlanResponse(
            name = javaType.name(),
            product = javaType.product(),
            promotionCode = javaType.promotionCode().map({ args0 -> args0 }).orElse(null),
            publisher = javaType.publisher(),
        )
    }
}
