@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Gallery regional sharing status
 * @property details Details of gallery regional sharing failure.
 * @property region Region name
 * @property state Gallery sharing state in current region
 */
public data class RegionalSharingStatusResponse(
    public val details: String? = null,
    public val region: String? = null,
    public val state: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.RegionalSharingStatusResponse): RegionalSharingStatusResponse = RegionalSharingStatusResponse(
            details = javaType.details().map({ args0 -> args0 }).orElse(null),
            region = javaType.region().map({ args0 -> args0 }).orElse(null),
            state = javaType.state(),
        )
    }
}
