@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * This is the replication status of the gallery image version.
 * @property aggregatedState This is the aggregated replication status based on all the regional replication status flags.
 * @property summary This is a summary of replication status for each region.
 */
public data class ReplicationStatusResponse(
    public val aggregatedState: String,
    public val summary: List<RegionalReplicationStatusResponse>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.ReplicationStatusResponse): ReplicationStatusResponse = ReplicationStatusResponse(
            aggregatedState = javaType.aggregatedState(),
            summary = javaType.summary().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.RegionalReplicationStatusResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
