@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The properties of the source resource that this restore point collection is created from.
 * @property id Resource Id of the source resource used to create this restore point collection
 * @property location Location of the source resource used to create this restore point collection.
 */
public data class RestorePointCollectionSourcePropertiesResponse(
    public val id: String? = null,
    public val location: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.RestorePointCollectionSourcePropertiesResponse): RestorePointCollectionSourcePropertiesResponse =
            RestorePointCollectionSourcePropertiesResponse(
                id = javaType.id().map({ args0 -> args0 }).orElse(null),
                location = javaType.location(),
            )
    }
}
