@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * The instance view of a restore point.
 * @property diskRestorePoints The disk restore points information.
 * @property statuses The resource status information.
 */
public data class RestorePointInstanceViewResponse(
    public val diskRestorePoints: List<DiskRestorePointInstanceViewResponse>? = null,
    public val statuses: List<InstanceViewStatusResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.RestorePointInstanceViewResponse): RestorePointInstanceViewResponse = RestorePointInstanceViewResponse(
            diskRestorePoints = javaType.diskRestorePoints().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.DiskRestorePointInstanceViewResponse.Companion.toKotlin(args0)
                })
            }),
            statuses = javaType.statuses().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.InstanceViewStatusResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
