@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Restore Point details.
 * @property consistencyMode ConsistencyMode of the RestorePoint. Can be specified in the input while creating a restore point. For now, only CrashConsistent is accepted as a valid input. Please refer to https://aka.ms/RestorePoints for more details.
 * @property excludeDisks List of disk resource ids that the customer wishes to exclude from the restore point. If no disks are specified, all disks will be included.
 * @property id Resource Id
 * @property instanceView The restore point instance view.
 * @property name Resource name
 * @property provisioningState Gets the provisioning state of the restore point.
 * @property sourceMetadata Gets the details of the VM captured at the time of the restore point creation.
 * @property sourceRestorePoint Resource Id of the source restore point from which a copy needs to be created.
 * @property timeCreated Gets the creation time of the restore point.
 * @property type Resource type
 */
public data class RestorePointResponse(
    public val consistencyMode: String? = null,
    public val excludeDisks: List<ApiEntityReferenceResponse>? = null,
    public val id: String,
    public val instanceView: RestorePointInstanceViewResponse,
    public val name: String,
    public val provisioningState: String,
    public val sourceMetadata: RestorePointSourceMetadataResponse? = null,
    public val sourceRestorePoint: ApiEntityReferenceResponse? = null,
    public val timeCreated: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.RestorePointResponse): RestorePointResponse = RestorePointResponse(
            consistencyMode = javaType.consistencyMode().map({ args0 -> args0 }).orElse(null),
            excludeDisks = javaType.excludeDisks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.ApiEntityReferenceResponse.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            instanceView = javaType.instanceView().let({ args0 ->
                com.pulumi.azurenative.compute.kotlin.outputs.RestorePointInstanceViewResponse.Companion.toKotlin(args0)
            }),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            sourceMetadata = javaType.sourceMetadata().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.RestorePointSourceMetadataResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            sourceRestorePoint = javaType.sourceRestorePoint().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.ApiEntityReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            timeCreated = javaType.timeCreated().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
