@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Describes a data disk.
 * @property caching Gets the caching type.
 * @property diskRestorePoint Contains Disk Restore Point properties.
 * @property diskSizeGB Gets the initial disk size in GB for blank data disks, and the new desired size for existing OS and Data disks.
 * @property lun Gets the logical unit number.
 * @property managedDisk Contains the managed disk details.
 * @property name Gets the disk name.
 * @property writeAcceleratorEnabled Shows true if the disk is write-accelerator enabled.
 */
public data class RestorePointSourceVMDataDiskResponse(
    public val caching: String,
    public val diskRestorePoint: DiskRestorePointAttributesResponse? = null,
    public val diskSizeGB: Int,
    public val lun: Int,
    public val managedDisk: ManagedDiskParametersResponse? = null,
    public val name: String,
    public val writeAcceleratorEnabled: Boolean,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.RestorePointSourceVMDataDiskResponse): RestorePointSourceVMDataDiskResponse = RestorePointSourceVMDataDiskResponse(
            caching = javaType.caching(),
            diskRestorePoint = javaType.diskRestorePoint().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.DiskRestorePointAttributesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            diskSizeGB = javaType.diskSizeGB(),
            lun = javaType.lun(),
            managedDisk = javaType.managedDisk().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.ManagedDiskParametersResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            name = javaType.name(),
            writeAcceleratorEnabled = javaType.writeAcceleratorEnabled(),
        )
    }
}
