@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Describes an Operating System disk.
 * @property caching Gets the caching type.
 * @property diskRestorePoint Contains Disk Restore Point properties.
 * @property diskSizeGB Gets the disk size in GB.
 * @property encryptionSettings Gets the disk encryption settings.
 * @property managedDisk Gets the managed disk details
 * @property name Gets the disk name.
 * @property osType Gets the Operating System type.
 * @property writeAcceleratorEnabled Shows true if the disk is write-accelerator enabled.
 */
public data class RestorePointSourceVMOSDiskResponse(
    public val caching: String,
    public val diskRestorePoint: DiskRestorePointAttributesResponse? = null,
    public val diskSizeGB: Int,
    public val encryptionSettings: DiskEncryptionSettingsResponse,
    public val managedDisk: ManagedDiskParametersResponse? = null,
    public val name: String,
    public val osType: String,
    public val writeAcceleratorEnabled: Boolean,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.RestorePointSourceVMOSDiskResponse): RestorePointSourceVMOSDiskResponse = RestorePointSourceVMOSDiskResponse(
            caching = javaType.caching(),
            diskRestorePoint = javaType.diskRestorePoint().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.DiskRestorePointAttributesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            diskSizeGB = javaType.diskSizeGB(),
            encryptionSettings = javaType.encryptionSettings().let({ args0 ->
                com.pulumi.azurenative.compute.kotlin.outputs.DiskEncryptionSettingsResponse.Companion.toKotlin(args0)
            }),
            managedDisk = javaType.managedDisk().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.ManagedDiskParametersResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            name = javaType.name(),
            osType = javaType.osType(),
            writeAcceleratorEnabled = javaType.writeAcceleratorEnabled(),
        )
    }
}
