@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * Describes the storage profile.
 * @property dataDisks Gets the data disks of the VM captured at the time of the restore point creation.
 * @property osDisk Gets the OS disk of the VM captured at the time of the restore point creation.
 */
public data class RestorePointSourceVMStorageProfileResponse(
    public val dataDisks: List<RestorePointSourceVMDataDiskResponse>? = null,
    public val osDisk: RestorePointSourceVMOSDiskResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.RestorePointSourceVMStorageProfileResponse): RestorePointSourceVMStorageProfileResponse = RestorePointSourceVMStorageProfileResponse(
            dataDisks = javaType.dataDisks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.RestorePointSourceVMDataDiskResponse.Companion.toKotlin(args0)
                })
            }),
            osDisk = javaType.osDisk().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.RestorePointSourceVMOSDiskResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
