@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * The configuration parameters used while performing a rolling upgrade.
 * @property enableCrossZoneUpgrade Allow VMSS to ignore AZ boundaries when constructing upgrade batches. Take into consideration the Update Domain and maxBatchInstancePercent to determine the batch size.
 * @property maxBatchInstancePercent The maximum percent of total virtual machine instances that will be upgraded simultaneously by the rolling upgrade in one batch. As this is a maximum, unhealthy instances in previous or future batches can cause the percentage of instances in a batch to decrease to ensure higher reliability. The default value for this parameter is 20%.
 * @property maxSurge Create new virtual machines to upgrade the scale set, rather than updating the existing virtual machines. Existing virtual machines will be deleted once the new virtual machines are created for each batch.
 * @property maxUnhealthyInstancePercent The maximum percentage of the total virtual machine instances in the scale set that can be simultaneously unhealthy, either as a result of being upgraded, or by being found in an unhealthy state by the virtual machine health checks before the rolling upgrade aborts. This constraint will be checked prior to starting any batch. The default value for this parameter is 20%.
 * @property maxUnhealthyUpgradedInstancePercent The maximum percentage of upgraded virtual machine instances that can be found to be in an unhealthy state. This check will happen after each batch is upgraded. If this percentage is ever exceeded, the rolling update aborts. The default value for this parameter is 20%.
 * @property pauseTimeBetweenBatches The wait time between completing the update for all virtual machines in one batch and starting the next batch. The time duration should be specified in ISO 8601 format. The default value is 0 seconds (PT0S).
 * @property prioritizeUnhealthyInstances Upgrade all unhealthy instances in a scale set before any healthy instances.
 * @property rollbackFailedInstancesOnPolicyBreach Rollback failed instances to previous model if the Rolling Upgrade policy is violated.
 */
public data class RollingUpgradePolicyResponse(
    public val enableCrossZoneUpgrade: Boolean? = null,
    public val maxBatchInstancePercent: Int? = null,
    public val maxSurge: Boolean? = null,
    public val maxUnhealthyInstancePercent: Int? = null,
    public val maxUnhealthyUpgradedInstancePercent: Int? = null,
    public val pauseTimeBetweenBatches: String? = null,
    public val prioritizeUnhealthyInstances: Boolean? = null,
    public val rollbackFailedInstancesOnPolicyBreach: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.RollingUpgradePolicyResponse): RollingUpgradePolicyResponse = RollingUpgradePolicyResponse(
            enableCrossZoneUpgrade = javaType.enableCrossZoneUpgrade().map({ args0 -> args0 }).orElse(null),
            maxBatchInstancePercent = javaType.maxBatchInstancePercent().map({ args0 -> args0 }).orElse(null),
            maxSurge = javaType.maxSurge().map({ args0 -> args0 }).orElse(null),
            maxUnhealthyInstancePercent = javaType.maxUnhealthyInstancePercent().map({ args0 ->
                args0
            }).orElse(null),
            maxUnhealthyUpgradedInstancePercent = javaType.maxUnhealthyUpgradedInstancePercent().map({ args0 ->
                args0
            }).orElse(null),
            pauseTimeBetweenBatches = javaType.pauseTimeBetweenBatches().map({ args0 -> args0 }).orElse(null),
            prioritizeUnhealthyInstances = javaType.prioritizeUnhealthyInstances().map({ args0 ->
                args0
            }).orElse(null),
            rollbackFailedInstancesOnPolicyBreach = javaType.rollbackFailedInstancesOnPolicyBreach().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
