@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Specifies the security posture to be used for all virtual machines in the scale set. Minimum api-version: 2023-03-01
 * @property excludeExtensions List of virtual machine extensions to exclude when applying the Security Posture.
 * @property id The security posture reference id in the form of /CommunityGalleries/{communityGalleryName}/securityPostures/{securityPostureName}/versions/{major.minor.patch}|{major.*}|latest
 */
public data class SecurityPostureReferenceResponse(
    public val excludeExtensions: List<VirtualMachineExtensionResponse>? = null,
    public val id: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.SecurityPostureReferenceResponse): SecurityPostureReferenceResponse = SecurityPostureReferenceResponse(
            excludeExtensions = javaType.excludeExtensions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.VirtualMachineExtensionResponse.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
        )
    }
}
