@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Specifies the Security profile settings for the virtual machine or virtual machine scale set.
 * @property encryptionAtHost This property can be used by user in the request to enable or disable the Host Encryption for the virtual machine or virtual machine scale set. This will enable the encryption for all the disks including Resource/Temp disk at host itself. The default behavior is: The Encryption at host will be disabled unless this property is set to true for the resource.
 * @property securityType Specifies the SecurityType of the virtual machine. It has to be set to any specified value to enable UefiSettings. The default behavior is: UefiSettings will not be enabled unless this property is set.
 * @property uefiSettings Specifies the security settings like secure boot and vTPM used while creating the virtual machine. Minimum api-version: 2020-12-01.
 */
public data class SecurityProfileResponse(
    public val encryptionAtHost: Boolean? = null,
    public val securityType: String? = null,
    public val uefiSettings: UefiSettingsResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.SecurityProfileResponse): SecurityProfileResponse = SecurityProfileResponse(
            encryptionAtHost = javaType.encryptionAtHost().map({ args0 -> args0 }).orElse(null),
            securityType = javaType.securityType().map({ args0 -> args0 }).orElse(null),
            uefiSettings = javaType.uefiSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.UefiSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
