@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Profile for gallery sharing to subscription or tenant
 * @property communityGalleryInfo Information of community gallery if current gallery is shared to community.
 * @property groups A list of sharing profile groups.
 * @property permissions This property allows you to specify the permission of sharing gallery. <br><br> Possible values are: <br><br> **Private** <br><br> **Groups** <br><br> **Community**
 */
public data class SharingProfileResponse(
    public val communityGalleryInfo: CommunityGalleryInfoResponse? = null,
    public val groups: List<SharingProfileGroupResponse>,
    public val permissions: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.SharingProfileResponse): SharingProfileResponse = SharingProfileResponse(
            communityGalleryInfo = javaType.communityGalleryInfo().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.CommunityGalleryInfoResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            groups = javaType.groups().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.SharingProfileGroupResponse.Companion.toKotlin(args0)
                })
            }),
            permissions = javaType.permissions().map({ args0 -> args0 }).orElse(null),
        )
    }
}
