@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * Describes a virtual machine scale set sku. NOTE: If the new VM SKU is not supported on the hardware the scale set is currently on, you need to deallocate the VMs in the scale set before you modify the SKU name.
 * @property capacity Specifies the number of virtual machines in the scale set.
 * @property name The sku name.
 * @property tier Specifies the tier of virtual machines in a scale set.<br /><br /> Possible Values:<br /><br /> **Standard**<br /><br /> **Basic**
 */
public data class SkuResponse(
    public val capacity: Double? = null,
    public val name: String? = null,
    public val tier: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.SkuResponse): SkuResponse =
            SkuResponse(
                capacity = javaType.capacity().map({ args0 -> args0 }).orElse(null),
                name = javaType.name().map({ args0 -> args0 }).orElse(null),
                tier = javaType.tier().map({ args0 -> args0 }).orElse(null),
            )
    }
}
