@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 * Contains information about the soft deletion policy of the gallery.
 * @property isSoftDeleteEnabled Enables soft-deletion for resources in this gallery, allowing them to be recovered within retention time.
 */
public data class SoftDeletePolicyResponse(
    public val isSoftDeleteEnabled: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.SoftDeletePolicyResponse): SoftDeletePolicyResponse = SoftDeletePolicyResponse(
            isSoftDeleteEnabled = javaType.isSoftDeleteEnabled().map({ args0 -> args0 }).orElse(null),
        )
    }
}
