@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Specifies the Spot-Try-Restore properties for the virtual machine scale set. With this property customer can enable or disable automatic restore of the evicted Spot VMSS VM instances opportunistically based on capacity availability and pricing constraint.
 * @property enabled Enables the Spot-Try-Restore feature where evicted VMSS SPOT instances will be tried to be restored opportunistically based on capacity availability and pricing constraints
 * @property restoreTimeout Timeout value expressed as an ISO 8601 time duration after which the platform will not try to restore the VMSS SPOT instances
 */
public data class SpotRestorePolicyResponse(
    public val enabled: Boolean? = null,
    public val restoreTimeout: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.SpotRestorePolicyResponse): SpotRestorePolicyResponse = SpotRestorePolicyResponse(
            enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
            restoreTimeout = javaType.restoreTimeout().map({ args0 -> args0 }).orElse(null),
        )
    }
}
