@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Specifies the storage settings for the virtual machine disks.
 * @property dataDisks Specifies the parameters that are used to add a data disk to a virtual machine. For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview).
 * @property diskControllerType Specifies the disk controller type configured for the VM. **Note:** This property will be set to the default disk controller type if not specified provided virtual machine is being created with 'hyperVGeneration' set to V2 based on the capabilities of the operating system disk and VM size from the the specified minimum api version. You need to deallocate the VM before updating its disk controller type unless you are updating the VM size in the VM configuration which implicitly deallocates and reallocates the VM. Minimum api-version: 2022-08-01.
 * @property imageReference Specifies information about the image to use. You can specify information about platform images, marketplace images, or virtual machine images. This element is required when you want to use a platform image, marketplace image, or virtual machine image, but is not used in other creation operations.
 * @property osDisk Specifies information about the operating system disk used by the virtual machine. For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview).
 */
public data class StorageProfileResponse(
    public val dataDisks: List<DataDiskResponse>? = null,
    public val diskControllerType: String? = null,
    public val imageReference: ImageReferenceResponse? = null,
    public val osDisk: OSDiskResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.StorageProfileResponse): StorageProfileResponse = StorageProfileResponse(
            dataDisks = javaType.dataDisks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.DataDiskResponse.Companion.toKotlin(args0)
                })
            }),
            diskControllerType = javaType.diskControllerType().map({ args0 -> args0 }).orElse(null),
            imageReference = javaType.imageReference().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.ImageReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            osDisk = javaType.osDisk().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.OSDiskResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
