@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * List of supported capabilities persisted on the disk resource for VM use.
 * @property acceleratedNetwork True if the image from which the OS disk is created supports accelerated networking.
 * @property architecture CPU architecture supported by an OS disk.
 * @property diskControllerTypes The disk controllers that an OS disk supports. If set it can be SCSI or SCSI, NVME or NVME, SCSI.
 */
public data class SupportedCapabilitiesResponse(
    public val acceleratedNetwork: Boolean? = null,
    public val architecture: String? = null,
    public val diskControllerTypes: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.SupportedCapabilitiesResponse): SupportedCapabilitiesResponse = SupportedCapabilitiesResponse(
            acceleratedNetwork = javaType.acceleratedNetwork().map({ args0 -> args0 }).orElse(null),
            architecture = javaType.architecture().map({ args0 -> args0 }).orElse(null),
            diskControllerTypes = javaType.diskControllerTypes().map({ args0 -> args0 }).orElse(null),
        )
    }
}
