@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The system meta data relating to this resource.
 * @property createdAt Specifies the time in UTC at which the Cloud Service (extended support) resource was created. <br />Minimum api-version: 2022-04-04.
 * @property lastModifiedAt Specifies the time in UTC at which the Cloud Service (extended support) resource was last modified. <br />Minimum api-version: 2022-04-04.
 */
public data class SystemDataResponse(
    public val createdAt: String,
    public val lastModifiedAt: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.SystemDataResponse): SystemDataResponse = SystemDataResponse(
            createdAt = javaType.createdAt(),
            lastModifiedAt = javaType.lastModifiedAt(),
        )
    }
}
