@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Describes the target region information.
 * @property encryption Optional. Allows users to provide customer managed keys for encrypting the OS and data disks in the gallery artifact.
 * @property excludeFromLatest Contains the flag setting to hide an image when users specify version='latest'
 * @property name The name of the region.
 * @property regionalReplicaCount The number of replicas of the Image Version to be created per region. This property is updatable.
 * @property storageAccountType Specifies the storage account type to be used to store the image. This property is not updatable.
 */
public data class TargetRegionResponse(
    public val encryption: EncryptionImagesResponse? = null,
    public val excludeFromLatest: Boolean? = null,
    public val name: String,
    public val regionalReplicaCount: Int? = null,
    public val storageAccountType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.TargetRegionResponse): TargetRegionResponse = TargetRegionResponse(
            encryption = javaType.encryption().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.EncryptionImagesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            excludeFromLatest = javaType.excludeFromLatest().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            regionalReplicaCount = javaType.regionalReplicaCount().map({ args0 -> args0 }).orElse(null),
            storageAccountType = javaType.storageAccountType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
