@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The instance view of the VM Agent running on the virtual machine.
 * @property extensionHandlers The virtual machine extension handler instance view.
 * @property statuses The resource status information.
 * @property vmAgentVersion The VM Agent full version.
 */
public data class VirtualMachineAgentInstanceViewResponse(
    public val extensionHandlers: List<VirtualMachineExtensionHandlerInstanceViewResponse>? = null,
    public val statuses: List<InstanceViewStatusResponse>? = null,
    public val vmAgentVersion: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.VirtualMachineAgentInstanceViewResponse): VirtualMachineAgentInstanceViewResponse = VirtualMachineAgentInstanceViewResponse(
            extensionHandlers = javaType.extensionHandlers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.VirtualMachineExtensionHandlerInstanceViewResponse.Companion.toKotlin(args0)
                })
            }),
            statuses = javaType.statuses().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.InstanceViewStatusResponse.Companion.toKotlin(args0)
                })
            }),
            vmAgentVersion = javaType.vmAgentVersion().map({ args0 -> args0 }).orElse(null),
        )
    }
}
